/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.persistence;

import com.jrockit.mc.common.persistence.LocalizedString;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;

public final class LocalizationToolkit {
    private static final Random s_randomNumberGenerator = new Random();

    private LocalizationToolkit() {
        throw new Error("Don't");
    }

    public static synchronized Map<String, String> createLocalizationMap(Setting root) {
        TreeMap<String, String> props = new TreeMap<String, String>();
        LocalizationToolkit.fillLocalizationMap(props, root);
        return props;
    }

    private static boolean isLocalizedString(Setting s) {
        return s.getProperties().containsKey("l10nKey");
    }

    public static String createLocalizationKey() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(LocalizationToolkit.createRandom16BitHex());
        buffer.append("-");
        buffer.append(LocalizationToolkit.createRandom16BitHex());
        buffer.append("-");
        buffer.append(LocalizationToolkit.createRandom16BitHex());
        buffer.append("-");
        buffer.append(LocalizationToolkit.createRandom16BitHex());
        return buffer.toString();
    }

    private static String createRandom16BitHex() {
        return String.format("%04X", s_randomNumberGenerator.nextInt(65536)).toUpperCase();
    }

    private static void fillLocalizationMap(Map<String, String> properties, Setting setting) {
        for (Setting s : setting.getChildren()) {
            if (LocalizationToolkit.isLocalizedString(s)) {
                String key = s.getChildObject("l10nKey", String.class);
                String value = s.getChildObject("default", String.class);
                properties.put(key, value);
                continue;
            }
            LocalizationToolkit.fillLocalizationMap(properties, s);
        }
    }

    public static List<LocalizedString> createLocalizationList(Object object) {
        Setting setting = PersistenceToolkit.getSetting(object);
        ArrayList<LocalizedString> strings = new ArrayList<LocalizedString>();
        LocalizationToolkit.fillLocalizationList(setting, strings);
        return strings;
    }

    private static void fillLocalizationList(Setting setting, List<LocalizedString> strings) {
        Setting[] settings;
        Setting[] settingArray = settings = setting.getChildren().toArray(new Setting[setting.getChildren().size()]);
        int n = settings.length;
        int n2 = 0;
        while (n2 < n) {
            Setting s = settingArray[n2];
            if (LocalizationToolkit.isLocalizedString(s)) {
                strings.add(s.getParent().getChildObject(s.getName(), LocalizedString.class));
            } else {
                LocalizationToolkit.fillLocalizationList(s, strings);
            }
            ++n2;
        }
    }
}

