/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.sampler;

import com.jrockit.mc.flightrecorder.spi.Expansion;
import com.jrockit.mc.flightrecorder.spi.IEventFilter;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.sampler.ISampler;
import com.jrockit.mc.flightrecorder.ui.sampler.SampleInfo;

public class TrackSampler
implements ISampler {
    private final SampleInfo m_sampleInformation = new SampleInfo(0);
    private IView m_view;

    @Override
    public boolean needsStructuralRefresh(ITimeRange range, int width) {
        if (this.m_sampleInformation.isStructuralDirty()) {
            return true;
        }
        if (width != this.m_sampleInformation.getSize()) {
            return true;
        }
        if (range.getStartTimestamp() != this.m_sampleInformation.getRange().getStartTimestamp()) {
            return true;
        }
        return range.getEndTimestamp() != this.m_sampleInformation.getRange().getEndTimestamp();
    }

    @Override
    public SampleInfo getSampleInfo() {
        return this.m_sampleInformation;
    }

    @Override
    public void setInput(Object input) {
        this.m_view = (IView)input;
    }

    @Override
    public final void sample(IEventFilter filter) {
        int size = this.m_sampleInformation.getSize();
        if (size > 0) {
            ITimeRange theSampleRange = this.getSampleInfo().getRange();
            long length = theSampleRange.getEndTimestamp() - theSampleRange.getStartTimestamp();
            long sampleRangeStart = theSampleRange.getStartTimestamp();
            if (length > 0L) {
                double length_per_pixel = (double)size / (double)length;
                this.m_view.setFilter(filter);
                this.m_view.setExpansion(Expansion.NORMAL);
                this.m_view.setRange(theSampleRange);
                for (ITimeRange range : this.m_view) {
                    this.addLayer(range, (double)(range.getStartTimestamp() - sampleRangeStart) * length_per_pixel, (double)(range.getEndTimestamp() + 1L - sampleRangeStart) * length_per_pixel, size);
                }
                this.getSampleInfo().setStructuralDirty(false);
            }
        }
    }

    private final void addLayer(ITimeRange e, double startPixel, double endPixel, int size) {
        int endSlot;
        double sp = startPixel < 0.0 ? 0.0 : startPixel;
        double ep = endPixel > (double)(size - 1) ? (double)(size - 1) : endPixel;
        int startSlot = startPixel < 0.0 ? 0 : (int)startPixel;
        int n = endSlot = endPixel < (double)(size - 1) ? (int)endPixel : size - 1;
        if (startSlot < size && endSlot >= 0) {
            if (startSlot == endSlot) {
                this.m_sampleInformation.addSample(startSlot, ep - sp, e);
            } else {
                this.m_sampleInformation.addSample(startSlot, 1.0 - (sp - (double)startSlot), e);
                this.m_sampleInformation.addSample(endSlot, ep - (double)endSlot, e);
                int n2 = startSlot + 1;
                while (n2 < endSlot) {
                    this.m_sampleInformation.addSample(n2, 1.0, e);
                    ++n2;
                }
            }
        }
    }
}

